function [data]=STM32F103_GET_PLOT_V3_5(skt)
  nharm=7_5;
%STM32F103_GET_PLOT_V3
  if(exist('skt')==0) skt=sktopen('192.168.1.4'); endif
  noplot=0;
  udpreset(skt);
  pkg load signal;

% Calibration initial match for rload only
  Vcal= 1*exp(-4.5*i*pi/180); % Compensate for phase angle into
  Ical=1;

  SRATE_MAX=875000;
  ADC_Scale = [248.34 0; 0 24];

  %tfz=exp(i*pi*113/180)/365;  % open circuit output impedance - measured by setting lod open and tfz=0;
  tfzs=udpget(skt,'tfz');
  tfz=tfzs(1)+i*tfzs(2);
  PartSerno=udpget(skt,'PartSerno');
  n=2048;
  win=flattopwin(n);
  win=sqrt(2)*win/(sum(win));
  win=win*ones(1,2);

  SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
  STM32F103_CC_SETUP_B3(skt);
  Tvec=(1:2048)/SRate;
  f=STM32F103_CC_GET(skt);
  atten=abs(1/(1+i*f*2*pi*1000*11e-12)); % Compensate for rc input in STM32ADC
  setenv('XDG_SESSION_TYPE','x11');


  harmhand=zeros(1,nharm);
  getno=0;

  Imp_Ave_sxy=0.0;
  Imp_Ave_sxx=0.0;
  Imp_Ave=0.0;
  Imp_Filt=0.05;
  Pow_Ave=0.0;

  while (min(size(kbhit(1)))<1)
    f=STM32F103_CC_GET(skt);
    bin=floor(0.5+((f/SRate)-floor(f/SRate))*2048)+1;
    if (bin>2048) bin=2048; endif
    dat=STM32F103_ADC_PLOT(skt,2048,-1)';
    md=ones(2048,1)*mean(dat);
    Vref_Scale=1.5/mean(mean(dat));
    data=(dat-md)*ADC_Scale*Vref_Scale/atten;

%    data=sin(bin*2*pi*(1:2048)/2048)'*ones(1,2);
    df=fft(data.*win);
    df(:,1)=df(:,1)*Vcal;
    df(:,2)=df(:,2)*Ical;
    df(:,2)=df(:,2)-tfz*df(:,1);
    df(:,1)=df(:,1)*1 ;
    if ((bin>3)&&(bin<2046))
    [dbin,didx]=max(abs(df(bin-1:(bin+1))));
    bin=bin+didx-2;
    endif
% Impedance filter
    Imp_Ave_sxy=((1-Imp_Filt)*Imp_Ave_sxy)+(Imp_Filt*(df(bin,1)*conj(df(bin,2))));
    Imp_Ave_sxx=((1-Imp_Filt)*Imp_Ave_sxx)+(Imp_Filt*(df(bin,2)*conj(df(bin,2))));
    Imp_Ave=Imp_Ave_sxy/Imp_Ave_sxx;
    Pow_Ave=Imp_Ave_sxy;

    res=[sprintf("Freqency=%2.4f MHz",f/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(df(bin,1)/df(bin,2)),(180/pi)*angle(df(bin,1)/df(bin,2)))
    sprintf("Impedance Average=%4.3f Ohms  %4.1f Degrees",abs(Imp_Ave),(180/pi)*angle(Imp_Ave))
    sprintf("Power    Real=%4.3f  Imag=%4.3f  W",real(df(bin,1)*df(bin,2)'),imag(df(bin,1)*df(bin,2)'))
    sprintf("Power Average   Real=%4.3f  Imag=%4.3f  W",real(Pow_Ave),imag(Pow_Ave))
    sprintf("Voltage = %4.3f Vrms",abs(df(bin,1)))
    sprintf("Current = %4.3f Irms",abs(df(bin,2)))
    sprintf("Part No.:%d Serial No.:%d",PartSerno(1),PartSerno(2))];

    if (getno<0.5)
     getno=1;

%     f3=figure(3);

%     set(f3,"numbertitle","off");
%     set(f3,'name','STM32F103_GET_PLOT');
     f1=figure(1);
     clf
     plot(Tvec,data');
     f1tit=title(res);


     grid on;
     figure(1)
     f1c=get(f1,'children');
     axis([0 2048/SRate -150 150]);
     f1cc=get(f1c,'children');
     legend(['Volts';'Amps ']);

     xlabel(['Seconds      ' sprintf('Sample Rate = %f',SRate)]   );
     ylabel('Volts');
     pb1=stopbut(f1,[1  5 55 22],"Zero tfz");
     pb2=stopbut(f1,[61  5 55 22],"Set tfz");
     pb3=stopbut(f1,[121  5 55 22],"Save tfz");


     f2=figure(2);
     clf;
     hold off;
     plot(20*log10(abs(df(2:2030,:))))
     axis([0 2048 -50 70]);
     grid on;
     ylabel('dB re 1 volt or 1 amp');
     xlabel('Frequency bin')
     f2c=get(f2,'children');
     f2cc=get(f2c,'children');
     t2=title(sprintf('Frequency = %fMHz',f/1e6));
     hold on
%     f3=plot(bin,60,'*');
     for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*2048)+1;
        if (bint>2048)
          bint=2048;
        endif
        harmhand(k)=text(bint,70-(3*k),sprintf("%df",k));
     end
     legend(['Volts';'Amps ']);



     commandwindow
    else


%     figure(1);
%     plot(Tvec,data);
     set(f1cc(2),'ydata',data(:,1)');
     set(f1cc(1),'ydata',data(:,2)');

     set(f1tit,'string',res);
%     title(sprintf('Frequency = %fMHz',f/1e6));


%     figure(2)
      hold off
%     plot(20*log10(abs(df(2:1023,:))))
      set(f2cc(2),'ydata',20*log10(abs(df(2:2030,1)))');
      set(f2cc(1),'ydata',20*log10(abs(df(2:2030,2)))');
      set(t2,'string',sprintf('Frequency = %fMHz  Bin - %d',f/1e6,bin));

      hold on
%      set(f3,'xdata',bin-1) ;
 %   plot(bin,10,'*');
      for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*2048)+1;
        if (bint>2048)
          bint=2048;
        endif
        set(harmhand(k),'position',[bint get(harmhand(k),'position')(2) 0]);
      end
     endif

     if(get(pb1,"value")==1)
      set(pb1,"value",0);
      tfz=0.0;
      Imp_Ave_sxy=0.0;
      Imp_Ave_syy=0.0;
     endif

     if(get(pb2,"value")==1)
      tfz=1/Imp_Ave;
      Imp_Ave_sxy=0.0;
      Imp_Ave_syy=0.0;
      set(pb2,"value",0);
     endif

    if(get(pb3,"value")==1)
      udpset(skt,'tfz',[real(tfz) imag(tfz)]);
      set(pb3,"value",0);
      udpprogconfig(skt);
     endif
   pause(0.1)
  endwhile

endfunction



function [pb]=stopbut(f,pos,txt)
 pb=uicontrol(...
 "style","togglebutton",...
 "string",txt,...
 "position",pos);
end

